﻿IF  EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_GetAppendedInterviewers]') AND type IN (N'P', N'PC'))
    DROP PROCEDURE [dbo].[sp_GetAppendedInterviewers]
GO

-- This stored procedure requires #Interviewers table to be created by the caller
CREATE PROCEDURE [dbo].[sp_GetAppendedInterviewers]
    @projectId INT,
	@unknownAgent NVARCHAR(19)
AS
BEGIN
    SET NOCOUNT ON;

    INSERT INTO #Interviewers
    SELECT DISTINCT
        H.[HisInterviewer] AS [ID], 
        CASE
            WHEN H.[HisInterviewer] IN (N'***', N'PD*')
                THEN H.[HisInterviewer]
            WHEN LTRIM(RTRIM(ISNULL(rch.[Name], '')))
                + LTRIM(RTRIM(ISNULL(TA.[FirstName], '')))
                + LTRIM(RTRIM(ISNULL(TA.[LastName],''))) <> ''
                THEN '(' + LTRIM(RTRIM(ISNULL(rch.[Name], ''))) + ') '
                + LTRIM(RTRIM(ISNULL(TA.[FirstName], ''))) + ' '
                + LTRIM(RTRIM(ISNULL(TA.[LastName], ''))) 
            WHEN I.[IntName] IS NOT NULL
                THEN I.[IntName]
                ELSE H.[HisInterviewer] + N' ' + @unknownAgent
        END AS [Name], 
        0 AS [NodeNotEmpty],
		0 AS [Status],
		0 AS [ItemType],
		@projectId AS [ParentID]
    FROM (
	    SELECT DISTINCT [HisInterviewer]
	    FROM [dbo].[Historic] WITH(NOLOCK)
	    WHERE [HisInterviewer] <> N'***'
	) H 
    LEFT JOIN [dbo].[tblObjects] rch WITH(NOLOCK) ON rch.[k_Id] = H.[HisInterviewer]
    LEFT JOIN [dbo].[tblAgents] TA WITH(NOLOCK) ON TA.[k_id] = CASE WHEN ISNUMERIC(H.[HisInterviewer]) <> 0
        THEN H.[HisInterviewer]
        ELSE -1
        END 
    LEFT JOIN [dbo].[Interviewer] I WITH(NOLOCK) ON I.[IntInitiale] = H.[HisInterviewer] 
    WHERE NOT EXISTS (
	    SELECT 1
		FROM #Interviewers i WITH(NOLOCK)
		WHERE i.[ID] = H.[HisInterviewer]
	);
END
GO
